/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.util.Locale;
import org.gradle.api.NonNullApi;

@NonNullApi
public class PathTraversalChecker {
    public static String safePathName(String name) {
        if (PathTraversalChecker.isUnsafePathName(name)) {
            throw new IllegalArgumentException(String.format("'%s' is not a safe archive entry or path name.", name));
        }
        return name;
    }

    public static boolean isUnsafePathName(String name) {
        return name.isEmpty() || name.startsWith("/") || name.startsWith("\\") || PathTraversalChecker.containsDirectoryNavigation(name) || name.contains(":") && PathTraversalChecker.isWindows();
    }

    private static boolean containsDirectoryNavigation(String name) {
        if (!name.contains("..")) {
            return false;
        }
        return name.endsWith("\\..") || name.contains("..\\") || name.endsWith("/..") || name.contains("../");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).contains("windows");
    }
}

